/* $Id: analog.c,v 1.10 1998/07/20 21:05:55 ericb Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Taken from E1431 library, heavily modified by Eric Backus */

#include "sema.h"

SHORTSIZ16 EXPORT
e1432_set_analog_input(E1432ID hw, SHORTSIZ16 ID, SHORTSIZ16 mode,
		       SHORTSIZ16 source, SHORTSIZ16 state,
		       SHORTSIZ16 coupling, FLOATSIZ32 range)
{
    SHORTSIZ16 error;

    TRACE_PRINTF(0, ("e1432_set_analog_input"
		     "(0x%p, %d, %d, %d, %d, %d, %f)\n",
		     hw, ID, mode, source, state, coupling, range));

    error = e1432_set_input_mode(hw, ID, mode);
    if (error)
	return error;

    error = e1432_set_input_high(hw, ID, source);
    if (error)
	return error;

    error = e1432_set_anti_alias_analog(hw, ID, state);
    if (error)
	return error;

    error = e1432_set_coupling(hw, ID, coupling);
    if (error)
	return error;

    switch(mode)
    {
	case E1432_INPUT_MODE_VOLT:
	case E1432_INPUT_MODE_ICP:
	    error = e1432_set_range(hw, ID, range);
	    break;
	case E1432_INPUT_MODE_CHARGE:
	    error = e1432_set_range_charge(hw, ID, range);
	    break;
	case E1432_INPUT_MODE_MIC:
	case E1432_INPUT_MODE_MIC_200V:
	    error = e1432_set_range_mike(hw, ID, range);
	    break;
	default:
	    return ERR1432_ILLEGAL_INPUT_MODE;
    }
    if (error)
	return error;

    return 0;
}
